﻿<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Kalend" %>
<%@ import Namespace="System.Collections.Generic" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
	<TITLE>Zatrudnienie na dzień</TITLE>
	<script runat="server">

    public class PrnParams : ContextBase {
        public PrnParams(Context context) : base(context) {
            data = ((ActualDate)Context[typeof(ActualDate)]).Actual;
        }

        Date data;
        [Caption("Stan na dzień")]
        public Date Data {
            get { return data; }
            set {
                data = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    PrnParams pars = null;
    [Context(Required = true)]
    public PrnParams Params {
        set { pars = value; }
    }

    class StanZatrudnienia {
        readonly Date data;

        public StanZatrudnienia(Date data) {
            this.data = data;
            pracOgolem = 0;
            pracKobiety = 0;
            pelnyOgolem = 0;
            pelnyKobiety = 0;
            niepelnyOgolem = 0;
            niepelnyKobiety = 0;
        }

        public void Dodaj(Pracownik prac) {
            PracHistoria ph = prac[data];
            if (!ph.Etat.OkresZatrudnienia.Contains(data))
                return;

            pracOgolem++;
            if (ph.Plec == PłećOsoby.Kobieta)
                pracKobiety++;

            decimal wymiar = (decimal)ph.Etat.Wymiar.Value;
            foreach (Pracownik pp in ph.Pracownik.Pracownicy)
                wymiar += (decimal)pp[ph.Aktualnosc.From].Etat.Wymiar.Value;

            if (wymiar >= 1) {
                pelnyOgolem++;
                if (ph.Plec == PłećOsoby.Kobieta)
                    pelnyKobiety++;
            }
            else {
                niepelnyOgolem++;
                if (ph.Plec == PłećOsoby.Kobieta)
                    niepelnyKobiety++;
            }
        }

        private int pracOgolem;
        public int PracOgolem {
            get { return pracOgolem; }
        }

        private int pracKobiety;
        public int PracKobiety {
            get { return pracKobiety; }
        }

        private int pelnyOgolem;
        public int PelnyOgolem {
            get { return pelnyOgolem; }
        }

        private int pelnyKobiety;
        public int PelnyKobiety {
            get { return pelnyKobiety; }
        }

        private int niepelnyOgolem;
        public int NiepelnyOgolem {
            get { return niepelnyOgolem; }
        }

        private int niepelnyKobiety;
        public int NiepelnyKobiety {
            get { return niepelnyKobiety; }
        }
    }

    void dc_ContextLoad(Object sender, EventArgs args) {
        ReportHeader["DZIEN"] = pars.Data.ToString();

        List<StanZatrudnienia> lst = new List<StanZatrudnienia>();
        StanZatrudnienia sz = new StanZatrudnienia(pars.Data);
        lst.Add(sz);

        List<Pracownik> pracownicy = new List<Pracownik>();
        SubTable st = KadryModule.GetInstance(dc).Pracownicy.WgNazwiska;
        foreach (Pracownik prac in st)
            if (!pracownicy.Contains(prac.EtatGłówny))
                pracownicy.Add(prac.EtatGłówny);

        foreach (Pracownik prac in pracownicy)
            if (prac.AccessRight != AccessRights.Denied)
                sz.Dodaj(prac);

        Grid1.DataSource = lst;
    }

	</script>
	
	<META content="C#" name="CODE_LANGUAGE">
	<META content="JavaScript" name="vs_defaultClientScript">
	<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:DataContext id="dc" oncontextload="dc_ContextLoad" runat="server"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader" runat="server" title="STAN ZATRUDNIENIA NA DZIEŃ %DZIEN%"></eb:ReportHeader>
			<ea:Grid id="Grid1" runat="server">
				<Columns>
					<ea:GridColumn runat="server" DataMember="PracOgolem" Align="Right" Caption="Pracownicy~Ogółem"></ea:GridColumn>
					<ea:GridColumn runat="server" DataMember="PracKobiety" Align="Right" Caption="Pracownicy~W tym kobiety"></ea:GridColumn>
					<ea:GridColumn runat="server" DataMember="PelnyOgolem" Align="Right" Caption="Pełnozatrudnieni~Ogółem"></ea:GridColumn>
					<ea:GridColumn runat="server" DataMember="PelnyKobiety" Align="Right" Caption="Pełnozatrudnieni~W tym kobiety"></ea:GridColumn>
					<ea:GridColumn runat="server" DataMember="NiepelnyOgolem" Align="Right" Caption="Niepełnozatrudnieni~Ogółem"></ea:GridColumn>
					<ea:GridColumn runat="server" DataMember="NiepelnyKobiety" Align="Right" Caption="Niepełnozatrudnieni~W tym kobiety"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</FORM>
	</BODY>
</HTML>

